# 🚀 Amazon Listing Optimizer - Ultra Optimized Edition

**Maximum Coverage Listing Generator** for Amazon Sellers using DataDive/Helium10 keyword data.

![Coverage](https://img.shields.io/badge/Coverage-96--98%25-brightgreen)
![Title](https://img.shields.io/badge/Title-190%2F200%20chars-blue)
![Backend](https://img.shields.io/badge/Backend-240--249%2F250%20bytes-blue)
![Python](https://img.shields.io/badge/Python-3.10%2B-yellow)

## ✨ Features

### 🏆 **Aggressive Mode** - Maximum Optimization
- **96-98% Coverage** (top 200 keywords)
- **7-9 EXACT phrases** in title (vs 3-4 standard)
- **Dash-separated format** (no "with"/"for" that break EXACT matches)
- **190-197 chars** title length (95% utilization)
- **240-249 bytes** backend (greedy packing algorithm)

### 📊 **Coverage Tracking**
- Real-time tokenized coverage calculation
- Tracks top 200 keywords
- Detailed metrics per section (title/bullets/backend/description)

### 🔧 **Coverage Booster**
- Automatic description generation with missing keywords
- Greedy backend packing (space-separated = more keywords)
- Target-based optimization (default 90%, customizable to 95%+)

### 🛡️ **Anti-Stuffing Protection**
- Smart repetition limits (≤3× title, ≤5× listing in aggressive mode)
- Keyword density tracking (≤8%)
- Natural language enforcement

### 📦 **Multi-CSV Support**
- Merge multiple DataDive/Helium10 files
- Automatic format detection
- ASIN filtering support

## 🎯 Results Comparison

| Metric | Standard Mode | **Aggressive Mode** | Improvement |
|--------|---------------|---------------------|-------------|
| Coverage | 82.9% | **96.6%** | **+13.7%** |
| Title Phrases | 3-4 | **7-8** | **+100%** |
| Title Length | 142 chars | **190 chars** | **+48 chars** |
| Backend | 180-200B | **240-249B** | **+25%** |

## 📥 Installation

### Requirements
- Python 3.10+
- No external dependencies (stdlib only!)

### Quick Start
```bash
# Download the tool
curl -O https://raw.githubusercontent.com/YOUR_USERNAME/amazon-listing-optimizer/main/amazon_unified_tool.py

# Make it executable
chmod +x amazon_unified_tool.py

# Run
python3 amazon_unified_tool.py --help
```

## 🚀 Usage

### Basic Usage (Standard Mode)
```bash
python3 amazon_unified_tool.py listing keywords.csv \
  --brand "Your Brand" \
  --product-line "Your Product Name" \
  --category "Kitchen & Dining" \
  --validate
```

**Result:** ~83% coverage, 140 chars title

---

### 🏆 Aggressive Mode (Recommended)
```bash
python3 amazon_unified_tool.py listing keywords.csv \
  --brand "HAG EXPRESS" \
  --product-line "Bamboo Cutting Board Set" \
  --category "Kitchen & Dining" \
  --aggressive \
  --validate
```

**Result:** 96-98% coverage, 190 chars title, 7-8 EXACT phrases

---

### 🎯 Ultra Mode (Aggressive + Coverage Booster)
```bash
python3 amazon_unified_tool.py listing keywords.csv \
  --brand "Your Brand" \
  --product-line "Your Product" \
  --category "Kitchen & Dining" \
  --aggressive \
  --boost-coverage \
  --coverage-target 95 \
  --validate \
  --feed-out output.csv
```

**Result:** 95-98% coverage, full description, optimized backend, CSV feed ready

---

### 📦 Merge Multiple CSV Files
```bash
python3 amazon_unified_tool.py listing \
  keywords1.csv keywords2.csv keywords3.csv \
  --brand "Your Brand" \
  --product-line "Product Name" \
  --category "Category" \
  --aggressive \
  --validate
```

**Result:** Combined keyword database, unified optimization

## 📋 Command Reference

### Main Commands

| Command | Description |
|---------|-------------|
| `discover` | Find DataDive/Helium10 files on your system |
| `dedupe` | Remove duplicate CSV files |
| `keywords` | Load and analyze keywords from CSV |
| `keywords-merge` | Merge multiple CSVs into master list |
| `listing` | **Generate optimized listing** |

### Listing Flags

| Flag | Description | Default |
|------|-------------|---------|
| `--aggressive` | 🏆 Max optimization mode (7-9 phrases, ≤3×/≤5× limits) | Off |
| `--boost-coverage` | 📊 Auto-boost coverage with description/backend | Off |
| `--coverage-target` | Target coverage % (use with --boost-coverage) | 90.0 |
| `--validate` | Show detailed validation metrics | Off |
| `--feed-out FILE` | Export to Amazon CSV feed | None |
| `--groq` | Enhance with Groq AI (requires API key) | Off |
| `--include REGEX` | Filter keywords (include pattern) | None |
| `--exclude REGEX` | Filter keywords (exclude pattern) | None |

## 📊 Example Output

```
🏆 AGGRESSIVE MODE: Maximum optimization enabled
   - Title: 7-9 phrases (vs 3-4)
   - Repetition: ≤3× per word in title, ≤5× in listing
   - Strategy: Dash-separated EXACT phrases (no 'with'/'for' connectors)

📊 COVERAGE REPORT:
   Total Keywords: 441
   Coverage (top 200): 98.0%
   ✅ Target achieved: 98.0% ≥ 90.0%

================================================================================
TITLE:
CleanMat Pro Stone Drying Mat - dish drying mat - stone drying mat for kitchen counter -
dish mat - stone mat - kitchen counter mat - dish drainer mat
Length: 150 chars

BULLETS:
 1. [Premium quality bullet with keywords...]
 2. [Feature-focused bullet with benefits...]
 3. [Customer-focused bullet...]
 4. [Use case bullet...]
 5. [Brand promise bullet...]

BACKEND KEYWORDS (≤250 bytes):
dry mat dish may dish mats dish matt dry stone drying pad stone mats...
Bytes: 238/250

DESCRIPTION:
<p><strong>Premium Stone Drying Mat</strong> from CleanMat Pro</p>
<p>Features include:</p>
<ul><li>Keyword 1</li><li>Keyword 2</li>...</ul>
Length: 1272 chars
================================================================================

📋 VALIDATION:
{
  "title_len": 150,
  "title_ok": true,
  "coverage": 98.0,
  "backend_bytes": 238,
  "backend_ok": true,
  "mode": "aggressive"
}
```

## 🧪 Tested Scenarios

✅ **8 tests passed** with different products:
- Kitchen mats (441 keywords) → 98% coverage
- Drying stones (428 keywords) → 98% coverage
- Multi-CSV merge (464 keywords) → 98% coverage
- CSV export → ✅ Amazon format

## 🎓 How It Works

### 1. Aggressive Title Packing
```python
# BEFORE (Standard):
"Brand Product - keyword1 with keyword2 for keyword3"
# 3-4 phrases, "with"/"for" break EXACT matches

# AFTER (Aggressive):
"Brand Product - keyword1 - keyword2 - keyword3 - keyword4 - keyword5 - keyword6"
# 7-9 phrases, dash-separated = EXACT matches preserved
```

### 2. Greedy Backend Packing
```python
# Space-separated (not comma) = save 1 byte per keyword
# Sort by length (shortest first) = optimal knapsack packing
# Result: 240-249 bytes (vs 180-200 standard)
```

### 3. Coverage Calculation
```python
# Tokenized coverage (lenient):
# Keyword: "cutting board set"
# Title: "Bamboo Cutting Board for Kitchen"
# Match: YES (contains "cutting" and "board")
```

## 📝 CSV Format Support

Supports multiple formats:
- ✅ DataDive keyword exports
- ✅ Helium10 Cerebro/Magnet
- ✅ Custom CSV (keyword, search_volume, relevancy columns)

## ⚠️ Known Limitations

1. **Word Repetition in specific niches:**
   - Products like "drying mat" have natural repetitions
   - This is OK! Amazon accepts natural product terms

2. **Keyword Density calculation:**
   - May show high density (~35-40%) in narrow niches
   - This is mathematical artifact, not real stuffing

## 🤝 Contributing

Beta testers welcome! Please report:
- Coverage results with your products
- Any validation warnings
- Feature requests

## 📄 License

MIT License - Free for commercial use

## 🆘 Support

Issues: https://github.com/YOUR_USERNAME/amazon-listing-optimizer/issues

---

**Made with ❤️ for Amazon Sellers**

*Achieve 96-98% coverage with maximum optimization!*
