# 📚 Usage Examples

## Quick Start Examples

### 1. Standard Mode (Basic)
```bash
python3 amazon_unified_tool.py listing my_keywords.csv \
  --brand "MyBrand" \
  --product-line "Coffee Grinder" \
  --category "Kitchen Appliances"
```

**Expected:**
- Coverage: ~80-85%
- Title: 140-150 chars
- 3-4 phrases in title

---

### 2. Aggressive Mode (Recommended)
```bash
python3 amazon_unified_tool.py listing my_keywords.csv \
  --brand "MyBrand" \
  --product-line "Coffee Grinder" \
  --category "Kitchen Appliances" \
  --aggressive
```

**Expected:**
- Coverage: 95-98%
- Title: 180-197 chars
- 7-9 EXACT phrases in title

---

### 3. Ultra Optimized (Aggressive + Booster)
```bash
python3 amazon_unified_tool.py listing my_keywords.csv \
  --brand "MyBrand" \
  --product-line "Coffee Grinder" \
  --category "Kitchen Appliances" \
  --aggressive \
  --boost-coverage \
  --coverage-target 95
```

**Expected:**
- Coverage: 95-98%
- Full HTML description
- Backend: 240-249 bytes
- Auto-generated CSV feed

---

## Real Product Examples

### Example 1: Kitchen Mat
```bash
python3 amazon_unified_tool.py listing \
  ~/Downloads/kitchen-mat-keywords.csv \
  --brand "CleanMat Pro" \
  --product-line "Stone Drying Mat" \
  --category "Kitchen & Dining" \
  --aggressive \
  --validate \
  --feed-out kitchen_mat_feed.csv
```

**Result:**
```
Coverage: 98.0%
Title: CleanMat Pro Stone Drying Mat - dish drying mat - stone drying mat for
       kitchen counter - dish mat - stone mat - kitchen counter mat
Backend: 238/250 bytes
```

---

### Example 2: Bamboo Cutting Board
```bash
python3 amazon_unified_tool.py listing \
  cutting_board_keywords.csv \
  --brand "HAG EXPRESS" \
  --product-line "Bamboo Cutting Board Set" \
  --category "Kitchen & Dining" \
  --attr "17x12" "14x10" "10x7.1" "4-Layer" "Stand" \
  --aggressive \
  --boost-coverage \
  --coverage-target 95 \
  --validate
```

**Result:**
```
Coverage: 96.6%
Title: HAG EXPRESS Bamboo Cutting Board Set - cutting board - bamboo cutting board -
       large cutting board - cutting board set - juice groove - reversible board
Backend: 245/250 bytes
```

---

### Example 3: Multi-Category Product (Multiple CSVs)
```bash
python3 amazon_unified_tool.py listing \
  keywords_main.csv \
  keywords_competitors.csv \
  keywords_listing_builder.csv \
  --brand "MegaBrand" \
  --product-line "Multi-Purpose Kitchen Tool" \
  --category "Kitchen & Dining" \
  --aggressive \
  --include "(kitchen|cook|prep)" \
  --exclude "(toy|kid|child)" \
  --validate
```

**Result:**
```
Total Keywords: 850 (merged from 3 files)
Coverage: 97.5%
Title: 195 chars (optimized)
```

---

## Advanced Usage

### Filter by Category
```bash
# Include only cutting board related keywords
python3 amazon_unified_tool.py listing keywords.csv \
  --brand "Brand" \
  --product-line "Product" \
  --category "Kitchen" \
  --include "(board|cut|bamboo|wood)" \
  --exclude "(toy|game|desk)" \
  --aggressive
```

---

### With Groq AI Enhancement
```bash
# Set API key first
export GROQ_API_KEY="gsk-your-key-here"

python3 amazon_unified_tool.py listing keywords.csv \
  --brand "Brand" \
  --product-line "Product" \
  --category "Kitchen" \
  --aggressive \
  --groq \
  --groq-model "llama-3.1-70b-versatile"
```

**Note:** Groq AI polishes the copy while maintaining limits

---

### Export JSON for API Integration
```bash
python3 amazon_unified_tool.py listing keywords.csv \
  --brand "Brand" \
  --product-line "Product" \
  --category "Kitchen" \
  --aggressive \
  --json > listing.json
```

**Output:**
```json
{
  "title": "Brand Product - keyword1 - keyword2...",
  "bullets": ["Bullet 1", "Bullet 2", ...],
  "backend_keywords": "keyword1 keyword2...",
  "description": "<p>HTML description</p>",
  "coverage": 96.5,
  "validation": {...}
}
```

---

## Utility Commands

### Find DataDive Files
```bash
python3 amazon_unified_tool.py discover \
  --roots ~/Downloads ~/Documents \
  --json
```

---

### Deduplicate CSVs
```bash
python3 amazon_unified_tool.py dedupe \
  --roots ~/Downloads \
  --quarantine ~/Desktop/_duplicates \
  --apply
```

---

### Merge Keywords Only (No Listing)
```bash
python3 amazon_unified_tool.py keywords-merge \
  keywords1.csv keywords2.csv keywords3.csv \
  --out master_keywords.csv \
  --top 500
```

---

## Tips for Best Results

### 1. Use Aggressive Mode for Competitive Niches
```bash
--aggressive --boost-coverage --coverage-target 95
```

### 2. Add Attributes for Size Variants
```bash
--attr "Large 17x12" "Medium 14x10" "Small 10x7"
```

### 3. Filter by Product Category
```bash
--include "(cutting|board|bamboo)"
--exclude "(drying|mat|stone)"
```

### 4. Always Validate
```bash
--validate
```

This shows:
- Title length (≤200 chars)
- Backend bytes (≤250)
- Word repetition violations
- Keyword density
- Coverage metrics

---

## Troubleshooting

### Low Coverage (<85%)
**Solution:** Use `--aggressive --boost-coverage`

### Title Too Short (<170 chars)
**Solution:** Use `--aggressive` (packs 7-9 phrases)

### Backend <230 bytes
**Solution:** Use `--aggressive` (greedy packing)

### Validation Warnings
**Solution:** Check `listing_word_repetition` - some are OK for product terms
