# 🧪 Beta Testing Guide

## Dla Beta Testerów

Dziękujemy za przetestowanie Amazon Listing Optimizer!

## 📥 Instalacja

### Krok 1: Pobierz program

**Opcja A - ZIP (najprostsze):**
1. Pobierz: `amazon-listing-optimizer-v1.0.zip`
2. Rozpakuj
3. Gotowe!

**Opcja B - Git:**
```bash
git clone https://github.com/USERNAME/amazon-listing-optimizer.git
cd amazon-listing-optimizer
```

### Krok 2: Sprawdź wersję Python
```bash
python3 --version
# Wymagane: Python 3.10 lub nowszy
```

### Krok 3: Test instalacji
```bash
python3 amazon_unified_tool.py --help
```

Jeśli widzisz menu pomocy - działa! ✅

---

## 🧪 Co Testować?

### Test 1: Podstawowa Generacja (5 min)
```bash
python3 amazon_unified_tool.py listing YOUR_KEYWORDS.csv \
  --brand "Your Brand" \
  --product-line "Your Product" \
  --category "Your Category" \
  --validate
```

**Sprawdź:**
- ✅ Coverage % (oczekiwane: ~83%)
- ✅ Title length
- ✅ Backend bytes

---

### Test 2: Tryb Aggressive (5 min)
```bash
python3 amazon_unified_tool.py listing YOUR_KEYWORDS.csv \
  --brand "Your Brand" \
  --product-line "Your Product" \
  --category "Your Category" \
  --aggressive \
  --validate
```

**Sprawdź:**
- ✅ Coverage % (oczekiwane: 95-98%)
- ✅ Title length (oczekiwane: 180-197 chars)
- ✅ Liczba fraz w Title (oczekiwane: 7-9)

---

### Test 3: Ultra Optimization (10 min)
```bash
python3 amazon_unified_tool.py listing YOUR_KEYWORDS.csv \
  --brand "Your Brand" \
  --product-line "Your Product" \
  --category "Your Category" \
  --aggressive \
  --boost-coverage \
  --coverage-target 95 \
  --validate \
  --feed-out output.csv
```

**Sprawdź:**
- ✅ Coverage ≥95%
- ✅ Description wygenerowany
- ✅ Backend ≥240 bytes
- ✅ CSV feed stworzony

---

## 📝 Co Zgłaszać?

### Format Raportu
```
Product Type: [np. Kitchen Mat, Coffee Grinder]
Keywords Count: [np. 441]
Mode Tested: [Standard/Aggressive/Ultra]

WYNIKI:
- Coverage: [X%]
- Title Length: [X chars]
- Backend Bytes: [X/250]
- Validation Warnings: [Lista lub "None"]

UWAGI:
[Twoje obserwacje]

PROBLEMY:
[Jeśli jakieś wystąpiły]
```

---

## 🎯 Najważniejsze Metryki

| Metryka | Standard | Aggressive | Twój Wynik |
|---------|----------|------------|------------|
| Coverage | 80-85% | 95-98% | ___% |
| Title Length | 140-150 | 180-197 | ___ chars |
| Title Phrases | 3-4 | 7-9 | ___ |
| Backend Bytes | 180-200 | 240-249 | ___/250 |

---

## ⚠️ Znane Ograniczenia

1. **Word Repetition Warnings:**
   - W niektorych niche (np. "drying mat", "stone mat") mogą pojawić się ostrzeżenia
   - To normalne! Amazon akceptuje naturalne product terms
   - Zgłoś jeśli repetition >10× dla jednego słowa

2. **Keyword Density >8%:**
   - W wąskich niche może pokazać wysoką density
   - To artifact matematyczny, nie prawdziwy stuffing
   - Zgłoś jeśli tekst wygląda nienaturalnie

---

## 🐛 Zgłaszanie Błędów

### Gdzie zgłaszać?
- Email: [your-email@example.com]
- GitHub Issues: [link-to-repo]/issues
- Discord: [optional]

### Informacje do dołączenia:
1. Python version (`python3 --version`)
2. Komenda użyta
3. Screenshot błędu (jeśli wystąpił)
4. Pierwszy wiersz CSV (header)
5. Ile keywords w pliku

---

## 💡 Sugestie Feature'ów

Jeśli masz pomysł na ulepszenie, zgłoś w formacie:

```
FEATURE: [Krótka nazwa]
OPIS: [Co ma robić]
PRZYKŁAD: [Jak użyć]
BENEFIT: [Dlaczego przydatne]
```

---

## 🏆 Nagrody dla Beta Testerów

- 🥇 Pierwsza osoba która znajdzie bug: **[nagroda]**
- 🥈 Najlepszy feature request: **[nagroda]**
- 🥉 Najwięcej testów: **[nagroda]**

---

## 📞 Kontakt

**Problemy techniczne:**
- GitHub Issues

**Pytania:**
- Email: [your-email]

**Sugestie:**
- Pull Requests welcome!

---

## ✅ Checklist dla Beta Testera

- [ ] Pobrałem i rozpakowałem program
- [ ] Sprawdziłem Python version
- [ ] Uruchomiłem `--help`
- [ ] Test #1: Standard mode
- [ ] Test #2: Aggressive mode
- [ ] Test #3: Ultra mode (z CSV export)
- [ ] Wypełniłem raport z wynikami
- [ ] Zgłosiłem feedback

---

**Dziękujemy za testowanie! 🚀**

Twój feedback pomoże ulepszyć narzędzie dla całej społeczności Amazon sellerów.
